/****************************************************************
*                                                               *
* Serão deletados os registros da tabela de análise diário      *
* com mais de 3 meses de vida.                                  *
*                                                               *
* Esta procedure é usualmente executada no job Manutenção dia 1	*
* Executar no banco Analise.                                    *
*                                                               *
****************************************************************/

IF EXISTS
(
	SELECT *
	FROM sys.objects
	WHERE object_id = OBJECT_ID(N'[dbo].[P_REMOVER_REGISTROS_ANALISE_DIARIA]')
		  AND type IN(N'P', N'PC')
)
	DROP PROCEDURE [dbo].[P_REMOVER_REGISTROS_ANALISE_DIARIA];
GO

CREATE PROCEDURE P_REMOVER_REGISTROS_ANALISE_DIARIA 
AS										
	--Declaração de variáveis
	DECLARE @CD_FILIAL int;
	DECLARE @RowCount int = 1
	
	--Inicia loop utilizando filiais necessárias
	print 'Obtendo as filiais
			Inicio: '+ convert(varchar,getdate());
			
	DECLARE CursorFiliais CURSOR FAST_FORWARD
		FOR	SELECT DISTINCT CD_FILIAL FROM EST_PROD_CPL_ANALISE_DIARIO;
		
	OPEN CursorFiliais;
	
	FETCH NEXT FROM CursorFiliais INTO @CD_FILIAL;
	WHILE @@FETCH_STATUS = 0
		BEGIN
			print 'Deletando vendas maiores que 3 meses da filial ' + convert(varchar,@CD_FILIAL) +'
													Inicio: '+ convert(varchar,getdate());
			--Realizando delete em lotes (batches)
			WHILE @RowCount > 0
			BEGIN
				DELETE TOP (10000) FROM EST_PROD_CPL_ANALISE_DIARIO WHERE DT_VD > DATEADD(month, -3, getdate())
														AND CD_FILIAL = @CD_FILIAL;
				SET @RowCount = @@ROWCOUNT
			END
			print 'Fim da limpeza da filial ' + convert(varchar,@CD_FILIAL) +'
													Fim: '+ convert(varchar,getdate());
			FETCH NEXT FROM CursorFiliais INTO @CD_FILIAL;
		END
	CLOSE CursorFiliais;
	DEALLOCATE CursorFiliais;